'Copyright (C) 2002 Microsoft Corporation
'All rights reserved.
'THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER 
'EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF 
'MERCHANTIBILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.

'Requires the Trial or Release version of Visual Studio .NET Professional (or greater).

Option Strict On

Imports System.Text

Public Class frmMain
	Inherits System.Windows.Forms.Form

    ' Declare necessary class variables.
    Private m_CommPort As New Rs232()
    Private m_IsModemFound As Boolean = False
    Private m_ModemPort As Integer = 0

#Region " Windows Form Designer generated code "

	Public Sub New()
		MyBase.New()

		'This call is required by the Windows Form Designer.
		InitializeComponent()

		'Add any initialization after the InitializeComponent() call

		' So that we only need to set the title of the application once,
		' we use the AssemblyInfo class (defined in the AssemblyInfo.vb file)
		' to read the AssemblyTitle attribute.
		Dim ainfo As New AssemblyInfo()

		Me.Text = ainfo.Title
        'Me.mnuAbout.Text = String.Format("&About {0} ...", ainfo.Title)

	End Sub

	'Form overrides dispose to clean up the component list.
	Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
		If disposing Then
			If Not (components Is Nothing) Then
				components.Dispose()
			End If
		End If
		MyBase.Dispose(disposing)
	End Sub

	'Required by the Windows Form Designer
	Private components As System.ComponentModel.IContainer

	'NOTE: The following procedure is required by the Windows Form Designer
	'It can be modified using the Windows Form Designer.  
	'Do not modify it using the code editor.
    Friend WithEvents txtStatus As System.Windows.Forms.TextBox
    Friend WithEvents tmrReadCommPort As System.Windows.Forms.Timer
    Friend WithEvents btnClear As System.Windows.Forms.Button
    Friend WithEvents btnSendIDN As System.Windows.Forms.Button
    Friend WithEvents btnREAD As System.Windows.Forms.Button
    Friend WithEvents mnuFile As System.Windows.Forms.MenuItem
    Friend WithEvents mnuExit As System.Windows.Forms.MenuItem
    Friend WithEvents mnuMain As System.Windows.Forms.MainMenu
    Friend WithEvents btnMeasureVDC As System.Windows.Forms.Button
    Friend WithEvents Label1 As System.Windows.Forms.Label
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.components = New System.ComponentModel.Container()
        Dim resources As System.Resources.ResourceManager = New System.Resources.ResourceManager(GetType(frmMain))
        Me.txtStatus = New System.Windows.Forms.TextBox()
        Me.tmrReadCommPort = New System.Windows.Forms.Timer(Me.components)
        Me.btnClear = New System.Windows.Forms.Button()
        Me.btnSendIDN = New System.Windows.Forms.Button()
        Me.btnREAD = New System.Windows.Forms.Button()
        Me.mnuFile = New System.Windows.Forms.MenuItem()
        Me.mnuExit = New System.Windows.Forms.MenuItem()
        Me.mnuMain = New System.Windows.Forms.MainMenu()
        Me.btnMeasureVDC = New System.Windows.Forms.Button()
        Me.Label1 = New System.Windows.Forms.Label()
        Me.SuspendLayout()
        '
        'txtStatus
        '
        Me.txtStatus.AccessibleDescription = resources.GetString("txtStatus.AccessibleDescription")
        Me.txtStatus.AccessibleName = resources.GetString("txtStatus.AccessibleName")
        Me.txtStatus.Anchor = CType(resources.GetObject("txtStatus.Anchor"), System.Windows.Forms.AnchorStyles)
        Me.txtStatus.AutoSize = CType(resources.GetObject("txtStatus.AutoSize"), Boolean)
        Me.txtStatus.BackgroundImage = CType(resources.GetObject("txtStatus.BackgroundImage"), System.Drawing.Image)
        Me.txtStatus.Dock = CType(resources.GetObject("txtStatus.Dock"), System.Windows.Forms.DockStyle)
        Me.txtStatus.Enabled = CType(resources.GetObject("txtStatus.Enabled"), Boolean)
        Me.txtStatus.Font = CType(resources.GetObject("txtStatus.Font"), System.Drawing.Font)
        Me.txtStatus.ImeMode = CType(resources.GetObject("txtStatus.ImeMode"), System.Windows.Forms.ImeMode)
        Me.txtStatus.Location = CType(resources.GetObject("txtStatus.Location"), System.Drawing.Point)
        Me.txtStatus.MaxLength = CType(resources.GetObject("txtStatus.MaxLength"), Integer)
        Me.txtStatus.Multiline = CType(resources.GetObject("txtStatus.Multiline"), Boolean)
        Me.txtStatus.Name = "txtStatus"
        Me.txtStatus.PasswordChar = CType(resources.GetObject("txtStatus.PasswordChar"), Char)
        Me.txtStatus.ReadOnly = True
        Me.txtStatus.RightToLeft = CType(resources.GetObject("txtStatus.RightToLeft"), System.Windows.Forms.RightToLeft)
        Me.txtStatus.ScrollBars = CType(resources.GetObject("txtStatus.ScrollBars"), System.Windows.Forms.ScrollBars)
        Me.txtStatus.Size = CType(resources.GetObject("txtStatus.Size"), System.Drawing.Size)
        Me.txtStatus.TabIndex = CType(resources.GetObject("txtStatus.TabIndex"), Integer)
        Me.txtStatus.Text = resources.GetString("txtStatus.Text")
        Me.txtStatus.TextAlign = CType(resources.GetObject("txtStatus.TextAlign"), System.Windows.Forms.HorizontalAlignment)
        Me.txtStatus.Visible = CType(resources.GetObject("txtStatus.Visible"), Boolean)
        Me.txtStatus.WordWrap = CType(resources.GetObject("txtStatus.WordWrap"), Boolean)
        '
        'tmrReadCommPort
        '
        '
        'btnClear
        '
        Me.btnClear.AccessibleDescription = resources.GetString("btnClear.AccessibleDescription")
        Me.btnClear.AccessibleName = resources.GetString("btnClear.AccessibleName")
        Me.btnClear.Anchor = CType(resources.GetObject("btnClear.Anchor"), System.Windows.Forms.AnchorStyles)
        Me.btnClear.BackgroundImage = CType(resources.GetObject("btnClear.BackgroundImage"), System.Drawing.Image)
        Me.btnClear.Dock = CType(resources.GetObject("btnClear.Dock"), System.Windows.Forms.DockStyle)
        Me.btnClear.Enabled = CType(resources.GetObject("btnClear.Enabled"), Boolean)
        Me.btnClear.FlatStyle = CType(resources.GetObject("btnClear.FlatStyle"), System.Windows.Forms.FlatStyle)
        Me.btnClear.Font = CType(resources.GetObject("btnClear.Font"), System.Drawing.Font)
        Me.btnClear.Image = CType(resources.GetObject("btnClear.Image"), System.Drawing.Image)
        Me.btnClear.ImageAlign = CType(resources.GetObject("btnClear.ImageAlign"), System.Drawing.ContentAlignment)
        Me.btnClear.ImageIndex = CType(resources.GetObject("btnClear.ImageIndex"), Integer)
        Me.btnClear.ImeMode = CType(resources.GetObject("btnClear.ImeMode"), System.Windows.Forms.ImeMode)
        Me.btnClear.Location = CType(resources.GetObject("btnClear.Location"), System.Drawing.Point)
        Me.btnClear.Name = "btnClear"
        Me.btnClear.RightToLeft = CType(resources.GetObject("btnClear.RightToLeft"), System.Windows.Forms.RightToLeft)
        Me.btnClear.Size = CType(resources.GetObject("btnClear.Size"), System.Drawing.Size)
        Me.btnClear.TabIndex = CType(resources.GetObject("btnClear.TabIndex"), Integer)
        Me.btnClear.Text = resources.GetString("btnClear.Text")
        Me.btnClear.TextAlign = CType(resources.GetObject("btnClear.TextAlign"), System.Drawing.ContentAlignment)
        Me.btnClear.Visible = CType(resources.GetObject("btnClear.Visible"), Boolean)
        '
        'btnSendIDN
        '
        Me.btnSendIDN.AccessibleDescription = CType(resources.GetObject("btnSendIDN.AccessibleDescription"), String)
        Me.btnSendIDN.AccessibleName = CType(resources.GetObject("btnSendIDN.AccessibleName"), String)
        Me.btnSendIDN.Anchor = CType(resources.GetObject("btnSendIDN.Anchor"), System.Windows.Forms.AnchorStyles)
        Me.btnSendIDN.BackgroundImage = CType(resources.GetObject("btnSendIDN.BackgroundImage"), System.Drawing.Image)
        Me.btnSendIDN.Dock = CType(resources.GetObject("btnSendIDN.Dock"), System.Windows.Forms.DockStyle)
        Me.btnSendIDN.Enabled = CType(resources.GetObject("btnSendIDN.Enabled"), Boolean)
        Me.btnSendIDN.FlatStyle = CType(resources.GetObject("btnSendIDN.FlatStyle"), System.Windows.Forms.FlatStyle)
        Me.btnSendIDN.Font = CType(resources.GetObject("btnSendIDN.Font"), System.Drawing.Font)
        Me.btnSendIDN.Image = CType(resources.GetObject("btnSendIDN.Image"), System.Drawing.Image)
        Me.btnSendIDN.ImageAlign = CType(resources.GetObject("btnSendIDN.ImageAlign"), System.Drawing.ContentAlignment)
        Me.btnSendIDN.ImageIndex = CType(resources.GetObject("btnSendIDN.ImageIndex"), Integer)
        Me.btnSendIDN.ImeMode = CType(resources.GetObject("btnSendIDN.ImeMode"), System.Windows.Forms.ImeMode)
        Me.btnSendIDN.Location = CType(resources.GetObject("btnSendIDN.Location"), System.Drawing.Point)
        Me.btnSendIDN.Name = "btnSendIDN"
        Me.btnSendIDN.RightToLeft = CType(resources.GetObject("btnSendIDN.RightToLeft"), System.Windows.Forms.RightToLeft)
        Me.btnSendIDN.Size = CType(resources.GetObject("btnSendIDN.Size"), System.Drawing.Size)
        Me.btnSendIDN.TabIndex = CType(resources.GetObject("btnSendIDN.TabIndex"), Integer)
        Me.btnSendIDN.Text = resources.GetString("btnSendIDN.Text")
        Me.btnSendIDN.TextAlign = CType(resources.GetObject("btnSendIDN.TextAlign"), System.Drawing.ContentAlignment)
        Me.btnSendIDN.Visible = CType(resources.GetObject("btnSendIDN.Visible"), Boolean)
        '
        'btnREAD
        '
        Me.btnREAD.AccessibleDescription = CType(resources.GetObject("btnREAD.AccessibleDescription"), String)
        Me.btnREAD.AccessibleName = CType(resources.GetObject("btnREAD.AccessibleName"), String)
        Me.btnREAD.Anchor = CType(resources.GetObject("btnREAD.Anchor"), System.Windows.Forms.AnchorStyles)
        Me.btnREAD.BackgroundImage = CType(resources.GetObject("btnREAD.BackgroundImage"), System.Drawing.Image)
        Me.btnREAD.Dock = CType(resources.GetObject("btnREAD.Dock"), System.Windows.Forms.DockStyle)
        Me.btnREAD.Enabled = CType(resources.GetObject("btnREAD.Enabled"), Boolean)
        Me.btnREAD.FlatStyle = CType(resources.GetObject("btnREAD.FlatStyle"), System.Windows.Forms.FlatStyle)
        Me.btnREAD.Font = CType(resources.GetObject("btnREAD.Font"), System.Drawing.Font)
        Me.btnREAD.Image = CType(resources.GetObject("btnREAD.Image"), System.Drawing.Image)
        Me.btnREAD.ImageAlign = CType(resources.GetObject("btnREAD.ImageAlign"), System.Drawing.ContentAlignment)
        Me.btnREAD.ImageIndex = CType(resources.GetObject("btnREAD.ImageIndex"), Integer)
        Me.btnREAD.ImeMode = CType(resources.GetObject("btnREAD.ImeMode"), System.Windows.Forms.ImeMode)
        Me.btnREAD.Location = CType(resources.GetObject("btnREAD.Location"), System.Drawing.Point)
        Me.btnREAD.Name = "btnREAD"
        Me.btnREAD.RightToLeft = CType(resources.GetObject("btnREAD.RightToLeft"), System.Windows.Forms.RightToLeft)
        Me.btnREAD.Size = CType(resources.GetObject("btnREAD.Size"), System.Drawing.Size)
        Me.btnREAD.TabIndex = CType(resources.GetObject("btnREAD.TabIndex"), Integer)
        Me.btnREAD.Text = resources.GetString("btnREAD.Text")
        Me.btnREAD.TextAlign = CType(resources.GetObject("btnREAD.TextAlign"), System.Drawing.ContentAlignment)
        Me.btnREAD.Visible = CType(resources.GetObject("btnREAD.Visible"), Boolean)
        '
        'mnuFile
        '
        Me.mnuFile.Enabled = CType(resources.GetObject("mnuFile.Enabled"), Boolean)
        Me.mnuFile.Index = 0
        Me.mnuFile.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuExit})
        Me.mnuFile.Shortcut = CType(resources.GetObject("mnuFile.Shortcut"), System.Windows.Forms.Shortcut)
        Me.mnuFile.ShowShortcut = CType(resources.GetObject("mnuFile.ShowShortcut"), Boolean)
        Me.mnuFile.Text = resources.GetString("mnuFile.Text")
        Me.mnuFile.Visible = CType(resources.GetObject("mnuFile.Visible"), Boolean)
        '
        'mnuExit
        '
        Me.mnuExit.Enabled = CType(resources.GetObject("mnuExit.Enabled"), Boolean)
        Me.mnuExit.Index = 0
        Me.mnuExit.Shortcut = CType(resources.GetObject("mnuExit.Shortcut"), System.Windows.Forms.Shortcut)
        Me.mnuExit.ShowShortcut = CType(resources.GetObject("mnuExit.ShowShortcut"), Boolean)
        Me.mnuExit.Text = resources.GetString("mnuExit.Text")
        Me.mnuExit.Visible = CType(resources.GetObject("mnuExit.Visible"), Boolean)
        '
        'mnuMain
        '
        Me.mnuMain.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuFile})
        Me.mnuMain.RightToLeft = CType(resources.GetObject("mnuMain.RightToLeft"), System.Windows.Forms.RightToLeft)
        '
        'btnMeasureVDC
        '
        Me.btnMeasureVDC.AccessibleDescription = CType(resources.GetObject("btnMeasureVDC.AccessibleDescription"), String)
        Me.btnMeasureVDC.AccessibleName = CType(resources.GetObject("btnMeasureVDC.AccessibleName"), String)
        Me.btnMeasureVDC.Anchor = CType(resources.GetObject("btnMeasureVDC.Anchor"), System.Windows.Forms.AnchorStyles)
        Me.btnMeasureVDC.BackgroundImage = CType(resources.GetObject("btnMeasureVDC.BackgroundImage"), System.Drawing.Image)
        Me.btnMeasureVDC.Dock = CType(resources.GetObject("btnMeasureVDC.Dock"), System.Windows.Forms.DockStyle)
        Me.btnMeasureVDC.Enabled = CType(resources.GetObject("btnMeasureVDC.Enabled"), Boolean)
        Me.btnMeasureVDC.FlatStyle = CType(resources.GetObject("btnMeasureVDC.FlatStyle"), System.Windows.Forms.FlatStyle)
        Me.btnMeasureVDC.Font = CType(resources.GetObject("btnMeasureVDC.Font"), System.Drawing.Font)
        Me.btnMeasureVDC.Image = CType(resources.GetObject("btnMeasureVDC.Image"), System.Drawing.Image)
        Me.btnMeasureVDC.ImageAlign = CType(resources.GetObject("btnMeasureVDC.ImageAlign"), System.Drawing.ContentAlignment)
        Me.btnMeasureVDC.ImageIndex = CType(resources.GetObject("btnMeasureVDC.ImageIndex"), Integer)
        Me.btnMeasureVDC.ImeMode = CType(resources.GetObject("btnMeasureVDC.ImeMode"), System.Windows.Forms.ImeMode)
        Me.btnMeasureVDC.Location = CType(resources.GetObject("btnMeasureVDC.Location"), System.Drawing.Point)
        Me.btnMeasureVDC.Name = "btnMeasureVDC"
        Me.btnMeasureVDC.RightToLeft = CType(resources.GetObject("btnMeasureVDC.RightToLeft"), System.Windows.Forms.RightToLeft)
        Me.btnMeasureVDC.Size = CType(resources.GetObject("btnMeasureVDC.Size"), System.Drawing.Size)
        Me.btnMeasureVDC.TabIndex = CType(resources.GetObject("btnMeasureVDC.TabIndex"), Integer)
        Me.btnMeasureVDC.Text = resources.GetString("btnMeasureVDC.Text")
        Me.btnMeasureVDC.TextAlign = CType(resources.GetObject("btnMeasureVDC.TextAlign"), System.Drawing.ContentAlignment)
        Me.btnMeasureVDC.Visible = CType(resources.GetObject("btnMeasureVDC.Visible"), Boolean)
        '
        'Label1
        '
        Me.Label1.AccessibleDescription = CType(resources.GetObject("Label1.AccessibleDescription"), String)
        Me.Label1.AccessibleName = CType(resources.GetObject("Label1.AccessibleName"), String)
        Me.Label1.Anchor = CType(resources.GetObject("Label1.Anchor"), System.Windows.Forms.AnchorStyles)
        Me.Label1.AutoSize = CType(resources.GetObject("Label1.AutoSize"), Boolean)
        Me.Label1.BackColor = System.Drawing.Color.White
        Me.Label1.Dock = CType(resources.GetObject("Label1.Dock"), System.Windows.Forms.DockStyle)
        Me.Label1.Enabled = CType(resources.GetObject("Label1.Enabled"), Boolean)
        Me.Label1.Font = CType(resources.GetObject("Label1.Font"), System.Drawing.Font)
        Me.Label1.Image = CType(resources.GetObject("Label1.Image"), System.Drawing.Image)
        Me.Label1.ImageAlign = CType(resources.GetObject("Label1.ImageAlign"), System.Drawing.ContentAlignment)
        Me.Label1.ImageIndex = CType(resources.GetObject("Label1.ImageIndex"), Integer)
        Me.Label1.ImeMode = CType(resources.GetObject("Label1.ImeMode"), System.Windows.Forms.ImeMode)
        Me.Label1.Location = CType(resources.GetObject("Label1.Location"), System.Drawing.Point)
        Me.Label1.Name = "Label1"
        Me.Label1.RightToLeft = CType(resources.GetObject("Label1.RightToLeft"), System.Windows.Forms.RightToLeft)
        Me.Label1.Size = CType(resources.GetObject("Label1.Size"), System.Drawing.Size)
        Me.Label1.TabIndex = CType(resources.GetObject("Label1.TabIndex"), Integer)
        Me.Label1.Text = resources.GetString("Label1.Text")
        Me.Label1.TextAlign = CType(resources.GetObject("Label1.TextAlign"), System.Drawing.ContentAlignment)
        Me.Label1.Visible = CType(resources.GetObject("Label1.Visible"), Boolean)
        '
        'frmMain
        '
        Me.AccessibleDescription = CType(resources.GetObject("$this.AccessibleDescription"), String)
        Me.AccessibleName = CType(resources.GetObject("$this.AccessibleName"), String)
        Me.Anchor = CType(resources.GetObject("$this.Anchor"), System.Windows.Forms.AnchorStyles)
        Me.AutoScaleBaseSize = CType(resources.GetObject("$this.AutoScaleBaseSize"), System.Drawing.Size)
        Me.AutoScroll = CType(resources.GetObject("$this.AutoScroll"), Boolean)
        Me.AutoScrollMargin = CType(resources.GetObject("$this.AutoScrollMargin"), System.Drawing.Size)
        Me.AutoScrollMinSize = CType(resources.GetObject("$this.AutoScrollMinSize"), System.Drawing.Size)
        Me.BackgroundImage = CType(resources.GetObject("$this.BackgroundImage"), System.Drawing.Image)
        Me.ClientSize = CType(resources.GetObject("$this.ClientSize"), System.Drawing.Size)
        Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.Label1, Me.btnMeasureVDC, Me.btnREAD, Me.btnSendIDN, Me.btnClear, Me.txtStatus})
        Me.Dock = CType(resources.GetObject("$this.Dock"), System.Windows.Forms.DockStyle)
        Me.Enabled = CType(resources.GetObject("$this.Enabled"), Boolean)
        Me.Font = CType(resources.GetObject("$this.Font"), System.Drawing.Font)
        Me.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle
        Me.Icon = CType(resources.GetObject("$this.Icon"), System.Drawing.Icon)
        Me.ImeMode = CType(resources.GetObject("$this.ImeMode"), System.Windows.Forms.ImeMode)
        Me.Location = CType(resources.GetObject("$this.Location"), System.Drawing.Point)
        Me.MaximizeBox = False
        Me.MaximumSize = CType(resources.GetObject("$this.MaximumSize"), System.Drawing.Size)
        Me.Menu = Me.mnuMain
        Me.MinimumSize = CType(resources.GetObject("$this.MinimumSize"), System.Drawing.Size)
        Me.Name = "frmMain"
        Me.RightToLeft = CType(resources.GetObject("$this.RightToLeft"), System.Windows.Forms.RightToLeft)
        Me.StartPosition = CType(resources.GetObject("$this.StartPosition"), System.Windows.Forms.FormStartPosition)
        Me.Text = resources.GetString("$this.Text")
        Me.Visible = CType(resources.GetObject("$this.Visible"), Boolean)
        Me.ResumeLayout(False)

    End Sub

#End Region

#Region " Standard Menu Code "

    ' This code will close the form.
    <System.Diagnostics.DebuggerStepThroughAttribute()> Private Sub mnuExit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuExit.Click
        ' Close the current form
        Me.Close()
    End Sub
#End Region

    ' This subroutine clears the TextBox.
    Private Sub btnClear_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnClear.Click
        Me.txtStatus.Clear()
    End Sub

    ' This subroutine is fired when the timer event is raised. It writes whatever
    '   is in the Comm Port buffer to the output window.
    Private Sub tmrReadCommPort_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tmrReadCommPort.Tick
        Try
            ' As long as there is information, read one byte at a time and 
            '   output it.
            While (m_CommPort.Read(1) <> -1)
                ' Write the output to the screen.
                WriteMessage(Chr(m_CommPort.InputStream(0)), False)
            End While
        Catch exc As Exception
            ' An exception is raised when there is no information to read.
            ' Don't do anything here, just let the exception go.
        End Try

    End Sub

    ' This function attempts to open the passed Comm Port. If it is
    '   available, it returns True, else it returns False. To determine
    '   availability a Try-Catch block is used.
    Private Function IsPortAvailable(ByVal ComPort As Integer) As Boolean
        Try
            m_CommPort.Open(ComPort, 115200, 8, Rs232.DataParity.Parity_None, _
                Rs232.DataStopBit.StopBit_1, 4096)
            ' If it makes it to here, then the Comm Port is available.
            m_CommPort.Close()
            Return True
        Catch
            ' If it gets here, then the attempt to open the Comm Port
            ' was unsuccessful.
            Return False
        End Try
    End Function

    ' This subroutine writes a message to the txtStatus TextBox.
    Private Sub WriteMessage(ByVal message As String)
        Me.txtStatus.Text += message + vbCrLf
    End Sub

    ' This subroutine writes a message to the txtStatus TextBox and allows
    '   the line feed to be suppressed.
    Private Sub WriteMessage(ByVal message As String, ByVal linefeed As Boolean)
        Me.txtStatus.Text += message
        If linefeed Then
            Me.txtStatus.Text += vbCrLf
        End If
    End Sub

    Private Sub btnSendIDN_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSendIDN.Click
        Me.txtStatus.Clear()
        ' Check for Availability of COM Port 1.
        Dim i As Integer
        i = 1   'for COM port 1
        WriteMessage("Testing COM" + i.ToString() + vbCrLf)
        If IsPortAvailable(i) Then
            WriteMessage("COM " + i.ToString() + " is ready" + vbCrLf)
        Else
            WriteMessage("COM " + i.ToString() + " is not ready" + vbCrLf)
        End If
        ' Attempt to open the port.
        m_CommPort.Open(i, 9600, 8, Rs232.DataParity.Parity_None, _
        Rs232.DataStopBit.StopBit_1, 4096)
        ' Write an Command to the instrument.
        m_CommPort.Write(Encoding.ASCII.GetBytes("*RST" & Chr(13)))
        m_CommPort.Write(Encoding.ASCII.GetBytes(":*IDN?" & Chr(13)))
        ' Sleep long enough for the instrument to execute commands
        ' across the RS232 port.
        System.Threading.Thread.Sleep(200)
        Application.DoEvents()
        btnREAD.Enabled = True
        btnMeasureVDC.Enabled = False
        WriteMessage("Command SENT" + vbCrLf + _
        "Press READ to identify instrument" + vbCrLf)
    End Sub

    Private Sub btnREAD_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnREAD.Click
        ' Always wrap up working with Comm Ports in exception handlers.
        Try
            ' Enable the timer for read.
            Me.tmrReadCommPort.Enabled = True
            System.Threading.Thread.Sleep(500)
            Application.DoEvents()
            m_CommPort.Close()

        Catch ex As Exception
            '   Don't do anything here, just let the exception go.
        Finally
            ' Disable the read timer.
            Me.tmrReadCommPort.Enabled = False
        End Try
        btnMeasureVDC.Enabled = True
    End Sub


    Private Sub btnMeasureVDC_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnMeasureVDC.Click
        Me.txtStatus.Clear()
        ' Check for Availability of COM Port 1.
        Dim i As Integer
        i = 1   'for COM port 1
        WriteMessage("Testing COM" + i.ToString() + vbCrLf)
        If IsPortAvailable(i) Then
            WriteMessage("COM " + i.ToString() + " is ready" + vbCrLf)
        Else
            WriteMessage("COM " + i.ToString() + " is not ready" + vbCrLf)
        End If
        ' Attempt to open the port.
        m_CommPort.Open(i, 9600, 8, Rs232.DataParity.Parity_None, _
        Rs232.DataStopBit.StopBit_1, 4096)
        ' Write an Command to the instrument.
        m_CommPort.Write(Encoding.ASCII.GetBytes("*RST" & Chr(13)))
        m_CommPort.Write(Encoding.ASCII.GetBytes(":SENS:FUNC 'VOLT:DC'" & Chr(13)))
        m_CommPort.Write(Encoding.ASCII.GetBytes(":SENS:VOLT:DC:RANG 10" & Chr(13)))
        m_CommPort.Write(Encoding.ASCII.GetBytes(":SENS:VOLT:DC:NPLC 0.1" & Chr(13)))
        m_CommPort.Write(Encoding.ASCII.GetBytes(":TRIG:SOUR IMM" & Chr(13)))
        m_CommPort.Write(Encoding.ASCII.GetBytes(":TRIG:COUN 1" & Chr(13)))
        m_CommPort.Write(Encoding.ASCII.GetBytes(":SAMP:COUN 1" & Chr(13)))
        m_CommPort.Write(Encoding.ASCII.GetBytes(":FORM:ELEM READ,UNITS" & Chr(13)))
        m_CommPort.Write(Encoding.ASCII.GetBytes(":READ?" & Chr(13)))
        WriteMessage("Commands to read VDC SENT" + vbCrLf)
        ' Sleep long enough for the instrument to execute commands and 
        ' transfer data via RS232 port.
        System.Threading.Thread.Sleep(1000)
        Application.DoEvents()
        ' Read result from instrument
        ' Could also delete code below and press the READ button to get results
        Try
            'Enable the timer for read.
            Me.tmrReadCommPort.Enabled = True
            System.Threading.Thread.Sleep(500)
            Application.DoEvents()
            m_CommPort.Close()

        Catch ex As Exception
            '   Don't do anything here, just let the exception go.
        Finally
            ' Disable the read timer.
            Me.tmrReadCommPort.Enabled = False
        End Try
    End Sub

End Class